<?php

include_once 'conexao.php';
 
class ModeloMateriaTema
{    
	static public function mdlAddMateriaTema($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO materiatema 
						(tema, idProfessor, dataCadastro,idVaga,ordem,tipoTema,dataInicio,dataExpiracao,horaInicial,horaFinal,notaMinimaParaAprovacao) VALUES 
						(:tema, :idProfessor, :dataCadastro,:idVaga,:ordem,:tipoTema,:dataInicio,:dataExpiracao,:horaInicial,:horaFinal,:notaMinimaParaAprovacao)");
		$stmt->bindParam(":idVaga", $dados["idVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":tema", $dados["tema"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":ordem", $dados["ordem"], PDO::PARAM_STR);
		$stmt->bindParam(":idProfessor", $dados["idUsuario"], PDO::PARAM_STR);
		$stmt->bindParam(":horaFinal", $dados["horaFinal"], PDO::PARAM_STR);
		$stmt->bindParam(":horaInicial", $dados["horaInicial"], PDO::PARAM_STR);
		$stmt->bindParam(":dataExpiracao", $dados["dataExpiracao"], PDO::PARAM_STR);
		$stmt->bindParam(":dataInicio", $dados["dataInicio"], PDO::PARAM_STR);
		$stmt->bindParam(":tipoTema", $dados["tipoTema"], PDO::PARAM_STR);
		$stmt->bindParam(":notaMinimaParaAprovacao", $dados["notaMinimaParaAprovacao"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

	static public function mdlMostrarTodasAsMateriaTemasDaVagaPoridVaga($idVaga) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM materiatema where idVaga = :idVaga order by idMateria");
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
		$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}  

	static public function mdlMostrarEOrdenarmateriatemasPorNumeroDeOrdemTodasAsmateriatemasDaVagaPoridVaga($idVaga) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM materiatema where idVaga = :idVaga order by idMateria");
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
		$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}

	static public function mdlVerificarMateriatemaPoridVagaETema($idVaga,$tema) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM materiatema where idVaga = :idVaga and tema = :tema order by idMateria");
		$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
		$stmt->bindParam(":tema", $tema, PDO::PARAM_STR);
		$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	} 

	static public function mdlMostrarmateriatemaPorIdmateriatema($idMateria) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM materiatema where idMateria = :idMateria");
		$stmt->bindParam(":idMateria", $idMateria, PDO::PARAM_STR);
		$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarmateriatemaPoridVagaENumeroDeOrdem($idVaga,$ordem) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM materiatema where idVaga = :idVaga and ordem = :ordem");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":ordem", $ordem, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlEditarMateriaTemaPorIdMateria($idMateria, $tema, $tipoTema,$notaMinima,$dataInicio,$dataExpiracao,$horaInicial,$horaFinal){
 
		$stmt = Conexao::conectar()->prepare("UPDATE materiatema SET  tema = :tema, tipoTema = :tipoTema, notaMinimaParaAprovacao = :notaMinimaParaAprovacao, dataInicio = :dataInicio, dataExpiracao = :dataExpiracao, horaInicial = :horaInicial, horaFinal = :horaFinal  where idMateria = :idMateria ");
		$stmt->bindParam(":idMateria", $idMateria, PDO::PARAM_STR);
		$stmt->bindParam(":tema", $tema, PDO::PARAM_STR);
		$stmt->bindParam(":tipoTema", $tipoTema, PDO::PARAM_STR);
		$stmt->bindParam(":notaMinimaParaAprovacao", $notaMinima, PDO::PARAM_STR);
		$stmt->bindParam(":dataInicio", $dataInicio, PDO::PARAM_STR);
		$stmt->bindParam(":dataExpiracao", $dataExpiracao, PDO::PARAM_STR);
		$stmt->bindParam(":horaInicial", $horaInicial, PDO::PARAM_STR);
		$stmt->bindParam(":horaFinal", $horaFinal, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlEliminarMateriaTemaaPorIdMateriaTema($id){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM materiatema where idMateria = :id ");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>